<?php $__env->startSection('title', 'خطط العلاج'); ?>

<?php $__env->startSection('content'); ?>

    <div class="content-header mb-3">
        <div class="d-flex justify-content-between align-items-center">
            <h5 class="mb-0">خطط العلاج</h5>
        </div>
    </div>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('error')): ?>
        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <div class="row">
        <div class="col-12">
            <div class="card table-card">
                <div class="card-header">
                    <h6 class="mb-0">قائمة خطط العلاج</h6>
                </div>
                <div class="card-body">

                    <div class="table-responsive">
                        <table class="table" id="pc-dt-simple">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>المريض</th>
                                <th>الطبيب</th>
                                <th>العنوان</th>
                                <th>الحالة</th>
                                <th>تاريخ الإنشاء</th>
                                <th class="text-center">إجراءات</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php
                                    $status = $plan->status;
                                    $badgeClass = match($status) {
                                        'draft'    => 'secondary',
                                        'ongoing'  => 'warning',
                                        'completed'=> 'success',
                                        'cancelled'=> 'danger',
                                        default    => 'secondary',
                                    };
                                ?>
                                <tr>
                                    <td><?php echo e($plan->id); ?></td>
                                    <td>
                                        <?php echo e($plan->patient?->first_name); ?> <?php echo e($plan->patient?->last_name); ?>

                                        <br>
                                        <small class="text-muted">كود: <?php echo e($plan->patient?->code ?? '-'); ?></small>
                                    </td>
                                    <td>
                                        <?php echo e($plan->doctor?->user?->name ?? '-'); ?>

                                    </td>
                                    <td><?php echo e($plan->title ?? '-'); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo e($badgeClass); ?>">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php switch($status):
                                                case ('draft'): ?> مسودة <?php break; ?>
                                                <?php case ('ongoing'): ?> جارية <?php break; ?>
                                                <?php case ('completed'): ?> مكتملة <?php break; ?>
                                                <?php case ('cancelled'): ?> ملغاة <?php break; ?>
                                                <?php default: ?> غير معروف
                                            <?php endswitch; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </span>
                                    </td>
                                    <td><?php echo e($plan->created_at?->format('Y-m-d')); ?></td>
                                    <td class="text-center">
                                        <div class="btn-group btn-sm btn-group-sm" role="group">
                                            <a href="<?php echo e(route('treatment-plans.show', $plan->id)); ?>"
                                               class="btn btn-primary">
                                                عرض
                                            </a>










                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center text-muted">
                                        لا توجد خطط علاج مسجلة حتى الآن.
                                    </td>
                                </tr>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        <?php echo e($plans->links()); ?>

                    </div>

                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\jops\SassMedical\resources\views/admin/treatment-plans/index.blade.php ENDPATH**/ ?>