<?php $__env->startSection('title', 'عرض الفاتورة #' . $invoice->invoice_number); ?>

<?php $__env->startSection('content'); ?>

    <div class="content-header d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">فاتورة رقم: <?php echo e($invoice->invoice_number); ?></h5>

        <div class="d-flex gap-2">
            <a href="<?php echo e(route('invoices.invoices_print', $invoice->id)); ?>" target="_blank" class="btn btn-sm btn-secondary">
                طباعة الفاتورة
            </a>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($invoice->patient): ?>
                <a href="<?php echo e(route('patients.show', $invoice->patient->id)); ?>" class="btn btn-sm btn-outline-primary">
                    ملف المريض
                </a>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <a href="<?php echo e(route('invoices.index')); ?>" class="btn btn-sm btn-outline-dark">
                كل الفواتير
            </a>
        </div>
    </div>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('error')): ?>
        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <div class="row gy-4">

        
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">بيانات الفاتورة</h6>
                </div>
                <div class="card-body">

                    <div class="row gy-2">
                        <div class="col-md-6">
                            <strong>رقم الفاتورة:</strong>
                            <div><?php echo e($invoice->invoice_number); ?></div>
                        </div>

                        <div class="col-md-6">
                            <strong>التاريخ:</strong>
                            <div><?php echo e($invoice->date->format('Y-m-d')); ?></div>
                        </div>

                        <div class="col-md-6">
                            <strong>المريض:</strong>
                            <div>
                                <?php echo e($invoice->patient?->first_name); ?> <?php echo e($invoice->patient?->last_name); ?>

                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($invoice->patient?->code): ?>
                                    <small class="text-muted">(<?php echo e($invoice->patient->code); ?>)</small>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <strong>الحالة:</strong>
                            <div>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php switch($invoice->status):
                                    case ('unpaid'): ?>
                                        <span class="badge bg-danger">غير مدفوعة</span>
                                        <?php break; ?>
                                    <?php case ('partial'): ?>
                                        <span class="badge bg-warning text-dark">مدفوعة جزئياً</span>
                                        <?php break; ?>
                                    <?php case ('paid'): ?>
                                        <span class="badge bg-success">مدفوعة بالكامل</span>
                                        <?php break; ?>
                                    <?php case ('refunded'): ?>
                                        <span class="badge bg-secondary">مسترجعة</span>
                                        <?php break; ?>
                                <?php endswitch; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <strong>الإجمالي الكلي:</strong>
                            <div>
                                <?php echo e(number_format($invoice->total, 2)); ?>

                                <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="16" height="16" alt="">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <strong>المدفوع:</strong>
                            <div>
                                <?php echo e(number_format($invoice->paid_amount, 2)); ?>

                                <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="16" height="16" alt="">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <strong>المتبقي:</strong>
                            <div>
                                <?php echo e(number_format($remaining, 2)); ?>

                                <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="16" height="16" alt="">
                            </div>
                        </div>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($invoice->payment_due_date): ?>
                            <div class="col-md-6">
                                <strong>تاريخ الاستحقاق:</strong>
                                <div><?php echo e($invoice->payment_due_date->format('Y-m-d')); ?></div>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                </div>
            </div>
        </div>

        
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">بنود الفاتورة</h6>
                </div>
                <div class="card-body">

                    <div class="table-responsive">
                        <table class="table table-sm table-striped align-middle">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>الوصف</th>
                                <th class="text-center">الكمية</th>
                                <th class="text-end">سعر الوحدة</th>
                                <th class="text-end">الخصم</th>
                                <th class="text-end">الإجمالي</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                                $row = 1;
                            ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $invoice->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($row++); ?></td>
                                    <td>
                                        <?php echo e($item->description); ?>

                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($item->service): ?>
                                            <br>
                                            <small class="text-muted">
                                                (خدمة: <?php echo e($item->service->name); ?>)
                                            </small>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </td>
                                    <td class="text-center"><?php echo e($item->quantity); ?></td>
                                    <td class="text-end">
                                        <?php echo e(number_format($item->unit_price, 2)); ?>

                                        <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="14" height="14" alt="">
                                    </td>
                                    <td class="text-end">
                                        <?php echo e(number_format($item->discount, 2)); ?>

                                        <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="14" height="14" alt="">
                                    </td>
                                    <td class="text-end">
                                        <?php echo e(number_format($item->line_total, 2)); ?>

                                        <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="14" height="14" alt="">
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </tbody>
                            <tfoot>
                            <tr>
                                <th colspan="5" class="text-end">الإجمالي قبل الخصم</th>
                                <th class="text-end">
                                    <?php echo e(number_format($invoice->subtotal, 2)); ?>

                                    <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="14" height="14" alt="">
                                </th>
                            </tr>
                            <tr>
                                <th colspan="5" class="text-end">إجمالي الخصم</th>
                                <th class="text-end">
                                    <?php echo e(number_format($invoice->discount, 2)); ?>

                                    <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="14" height="14" alt="">
                                </th>
                            </tr>
                            <tr>
                                <th colspan="5" class="text-end">
                                    الضريبة (<?php echo e(number_format($invoice->tax_percent, 2)); ?>%)
                                </th>
                                <th class="text-end">
                                    <?php echo e(number_format($invoice->tax_amount, 2)); ?>

                                    <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="14" height="14" alt="">
                                </th>
                            </tr>
                            <tr>
                                <th colspan="5" class="text-end fw-bold">الإجمالي النهائي</th>
                                <th class="text-end fw-bold">
                                    <?php echo e(number_format($invoice->total, 2)); ?>

                                    <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="14" height="14" alt="">
                                </th>
                            </tr>
                            </tfoot>
                        </table>
                    </div>

                </div>
            </div>
        </div>

        
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="mb-0">المدفوعات على الفاتورة</h6>

                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($remaining > 0): ?>
                        <span class="badge bg-warning text-dark">
                            المتبقي: <?php echo e(number_format($remaining, 2)); ?>

                            <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="14" height="14" alt="">
                        </span>
                    <?php else: ?>
                        <span class="badge bg-success">لا يوجد متبقي</span>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
                <div class="card-body">

                    
                    <div class="table-responsive mb-3">
                        <table class="table table-sm table-striped align-middle">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>التاريخ</th>
                                <th>المبلغ</th>
                                <th>طريقة الدفع</th>
                                <th>رقم العملية</th>
                                <th>ملاحظات</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $invoice->payments->sortBy('paid_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pay): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($pay->id); ?></td>
                                    <td><?php echo e($pay->paid_at->format('Y-m-d H:i')); ?></td>
                                    <td>
                                        <?php echo e(number_format($pay->amount, 2)); ?>

                                        <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="14" height="14" alt="">
                                    </td>
                                    <td>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php switch($pay->payment_method):
                                            case ('cash'): ?> كاش <?php break; ?>
                                            <?php case ('card'): ?> بطاقة <?php break; ?>
                                            <?php case ('bank_transfer'): ?> تحويل بنكي <?php break; ?>
                                            <?php case ('online'): ?> أونلاين <?php break; ?>
                                        <?php endswitch; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </td>
                                    <td><?php echo e($pay->transaction_id ?: '-'); ?></td>
                                    <td><?php echo e($pay->notes ?: '-'); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center text-muted">
                                        لا توجد مدفوعات مسجلة على هذه الفاتورة.
                                    </td>
                                </tr>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($remaining > 0): ?>
                        <form action="<?php echo e(route('payments.store')); ?>" method="POST" class="row g-2 align-items-end">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="invoice_id" value="<?php echo e($invoice->id); ?>">

                            <div class="col-md-3">
                                <label class="form-label">المتبقي الحالي</label>
                                <input type="text" class="form-control" value="<?php echo e(number_format($remaining, 2)); ?>"
                                       disabled>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">المبلغ المراد دفعه *</label>
                                <input type="number" step="0.01" min="0.01"
                                       max="<?php echo e($remaining); ?>"
                                       name="amount"
                                       class="form-control"
                                       value="<?php echo e($remaining); ?>" required>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">طريقة الدفع *</label>
                                <select name="payment_method" class="form-select" required>
                                    <option value="cash">كاش</option>
                                    <option value="card">بطاقة</option>
                                    <option value="bank_transfer">تحويل بنكي</option>
                                    <option value="online">أونلاين</option>
                                </select>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">رقم العملية (اختياري)</label>
                                <input type="text" name="transaction_id" class="form-control">
                            </div>

                            <div class="col-md-12 mt-2">
                                <label class="form-label">ملاحظات (اختياري)</label>
                                <textarea name="notes" rows="2" class="form-control"></textarea>
                            </div>

                            <div class="col-12 text-end mt-2">
                                <button type="submit" class="btn btn-success">
                                    تسجيل دفعة
                                </button>
                            </div>
                        </form>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                </div>
            </div>
        </div>

    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\jops\SassMedical\resources\views/admin/invoices/show.blade.php ENDPATH**/ ?>