

<?php $__env->startSection('title'); ?>
    تعديل بيانات الدكتور
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-lg-12 offset-lg-2">

            <div class="card shadow-sm">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">تعديل بيانات الدكتور</h5>
                    <a href="<?php echo e(route('doctors.show', $doctor->id)); ?>" class="btn btn-sm btn-secondary">
                        رجوع لصفحة الدكتور
                    </a>
                </div>

                <div class="card-body">

                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <strong>خطأ!</strong> من فضلك تأكد من إدخال البيانات بشكل صحيح.
                            <ul class="mb-0 mt-2">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </ul>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    <form action="<?php echo e(route('doctors.update', $doctor->id)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">اسم الدكتور *</label>
                                <input type="text" name="name" class="form-control"
                                       value="<?php echo e(old('name', $doctor->name)); ?>" required>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">البريد الإلكتروني *</label>
                                <input type="email" name="email" class="form-control"
                                       value="<?php echo e(old('email', $doctor->email)); ?>" required>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">الجوال</label>
                                <input type="text" name="phone" class="form-control"
                                       value="<?php echo e(old('phone', $doctor->phone)); ?>">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">كلمة المرور الجديدة</label>
                                <input type="password" name="password" class="form-control"
                                       placeholder="اتركها فارغة للإبقاء على الحالية">
                            </div>
                        </div>

                        
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label class="form-label">التخصص *</label>
                                <select name="specialty_id" class="form-select" required>
                                    <option value="">اختر التخصص</option>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $specialties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specialty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($specialty->id); ?>"
                                            <?php echo e(old('specialty_id', $doctor->doctorProfile?->specialty_id) == $specialty->id ? 'selected' : ''); ?>>
                                            <?php echo e($specialty->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </select>
                            </div>


                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">العيادة</label>
                                <input type="text" class="form-control"
                                       value="<?php echo e($doctor->clinic?->name ?? '-'); ?>" disabled>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">الفرع</label>
                                <input type="text" class="form-control"
                                       value="<?php echo e($doctor->branch?->name ?? '-'); ?>" disabled>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end mt-3">
                            <button type="submit" class="btn btn-success">
                                حفظ التعديلات
                            </button>
                        </div>

                    </form>

                </div>
            </div>

        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        const isActiveSwitch = document.getElementById('is_active_switch');
        const isActiveLabel  = document.querySelector('label[for="is_active_switch"]');

        if (isActiveSwitch && isActiveLabel) {
            isActiveSwitch.addEventListener('change', function () {
                if (this.checked) {
                    isActiveLabel.textContent = 'نشط';
                } else {
                    isActiveLabel.textContent = 'غير نشط';
                }
            });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\jops\SassMedical\resources\views/admin/doctors/edit.blade.php ENDPATH**/ ?>