<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('title', 'دكاترة تخصص: ' . $specialty->name); ?>


<?php $__env->startSection('content'); ?>

    <div class="content-header mb-3">
        <div class="d-flex justify-content-between align-items-center">

            <h5 class="mb-0">
                دكاترة تخصص: <?php echo e($specialty->name); ?>

            </h5>

            <div class="d-flex align-items-center gap-2">
                <a href="<?php echo e(route('doctors.create', ['specialty_id' => $specialty->id])); ?>"
                   class="btn btn-sm btn-success">
                    إضافة دكتور لهذا التخصص
                </a>

                <a href="<?php echo e(route('specialty.index')); ?>"
                   class="btn btn-sm btn-info">
                    صفحة التخصصات
                </a>
            </div>

        </div>
    </div>


    <div class="card shadow-sm">
        <div class="card-body">

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($specialty->doctorProfiles->count()): ?>

                <div class="table-responsive">
                    <table class="table table-striped table-sm">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>اسم الدكتور</th>
                            <th>العيادة</th>
                            <th>الفرع</th>
                            <th>الجوال</th>
                            <th>الحالة</th>
                            <th>العمليات</th>
                        </tr>
                        </thead>

                        <tbody>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $specialty->doctorProfiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $profile): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($profile->id); ?></td>
                                <td><?php echo e($profile->user->name); ?></td>
                                <td><?php echo e($profile->user->clinic?->name ?? '-'); ?></td>
                                <td><?php echo e($profile->branch?->name ?? '-'); ?></td>
                                <td><?php echo e($profile->user->phone); ?></td>
                                <td>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input doctor-status-switch"
                                               type="checkbox"
                                               id="doctorSwitch<?php echo e($profile->user->id); ?>"
                                               data-id="<?php echo e($profile->user->id); ?>"
                                            <?php echo e($profile->user->is_active ? 'checked' : ''); ?>>

                                        <label class="form-check-label" for="doctorSwitch<?php echo e($profile->user->id); ?>">
                                            <?php echo e($profile->user->is_active ? 'نشط' : 'غير نشط'); ?>

                                        </label>
                                    </div>
                                </td>


                                <td>
                                    <a href="<?php echo e(route('doctors.show', $profile->user_id)); ?>" class="btn btn-sm btn-outline-info">
                                        عرض
                                    </a>
                                    <a href="<?php echo e(route('doctors.edit', $profile->user_id)); ?>" class="btn btn-sm btn-outline-primary">
                                        تعديل
                                    </a>

                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </tbody>
                    </table>
                </div>

            <?php else: ?>
                <p class="text-center text-muted">
                    لا يوجد دكاترة مسجلين لهذا التخصص.
                </p>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {

            const switches = document.querySelectorAll('.doctor-status-switch');

            switches.forEach(function (sw) {
                sw.addEventListener('change', function () {
                    const userId = this.getAttribute('data-id');
                    const isActive = this.checked ? 1 : 0;
                    const label    = this.closest('.form-check').querySelector('.form-check-label');

                    fetch("<?php echo e(route('doctors.toggleStatus')); ?>", {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                            'Accept': 'application/json'
                        },
                        body: JSON.stringify({
                            id: userId,
                            is_active: isActive
                        })
                    })
                        .then(response => response.json())
                        .then(data => {
                            if (data.status === true) {
                                label.textContent = isActive ? 'نشط' : 'غير نشط';

                                if (window.toastr) {
                                    toastr.success(data.message || 'تم تحديث حالة الدكتور بنجاح');
                                }
                            } else {
                                sw.checked = !isActive;
                                label.textContent = !isActive ? 'نشط' : 'غير نشط';

                                if (window.toastr) {
                                    toastr.error(data.message || 'حدث خطأ أثناء تحديث الحالة');
                                }
                            }
                        })
                        .catch(err => {
                            sw.checked = !isActive;
                            label.textContent = !isActive ? 'نشط' : 'غير نشط';

                            if (window.toastr) {
                                toastr.error('تعذر الاتصال بالسيرفر');
                            }
                        });
                });
            });

        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\jops\SassMedical\resources\views/admin/specialty/doctors.blade.php ENDPATH**/ ?>