<?php

use App\Http\Controllers\DashboardController;
use App\Http\Controllers\Doctors\DoctorController;
use App\Http\Controllers\Inventory\InventoryItemController;
use App\Http\Controllers\Inventory\StockMovementController;
use App\Http\Controllers\Invoices\InvoiceController;
use App\Http\Controllers\Invoices\PaymentController;
use App\Http\Controllers\Patients\AttachmentController;
use App\Http\Controllers\Patients\PatientController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\Services\ServiceController;
use App\Http\Controllers\Setting\ClinicSettingController;
use App\Http\Controllers\Setting\UserController;
use App\Http\Controllers\specialty\specialtyController;
use App\Http\Controllers\Treatment\TreatmentPlanController;
use App\Http\Controllers\Treatment\TreatmentPlanItemController;
use Illuminate\Support\Facades\Route;

Route::get('/test', function () {
    return view('welcome');
});

Route::middleware(['auth','role'])->group(function () {



    Route::get('/',[DashboardController::class,'index'])->name('dashboard.index');

    /*
    |--------------------------------------------------------------------------
    | Patients Module
    |--------------------------------------------------------------------------
    */
    Route::get('/ajax/patients/search', [PatientController::class, 'ajaxSearch'])

        ->name('patients.ajax.search');

    Route::prefix('patients')->name('patients.')->group(function () {
        Route::get('/', [PatientController::class, 'index'])->name('index');
        Route::get('/create', [PatientController::class, 'create'])->name('create');
        Route::post('/', [PatientController::class, 'store'])->name('store');
        Route::get('/{id}', [PatientController::class, 'show'])->name('show');
        Route::get('/{id}/edit', [PatientController::class, 'edit'])->name('edit');
        Route::put('/{id}', [PatientController::class, 'update'])->name('update');
        Route::delete('/{id}', [PatientController::class, 'destroy'])->name('destroy');

        // Attachments
        Route::post('/attachments', [AttachmentController::class, 'store'])
            ->name('attachments.store');
        Route::delete('/attachment/{id}', [AttachmentController::class, 'destroy'])
            ->name('attachments.destroy');

        Route::get('/prescriptions/{prescription}/print', [PatientController::class, 'print'])
            ->name('prescriptions.print');
    });








    /*
    |--------------------------------------------------------------------------
    | Doctors Module
    |--------------------------------------------------------------------------
    */
    Route::prefix('doctors')->name('doctors.')->group(function () {
        Route::get('/', [DoctorController::class, 'index'])->name('index');
        Route::get('/create', [DoctorController::class, 'create'])->name('create');
        Route::post('/', [DoctorController::class, 'store'])->name('store');
        Route::get('/{id}', [DoctorController::class, 'show'])->name('show');
        Route::get('/{id}/edit', [DoctorController::class, 'edit'])->name('edit');
        Route::put('/{id}', [DoctorController::class, 'update'])->name('update');
        Route::delete('/{id}', [DoctorController::class, 'destroy'])->name('destroy');
        Route::post('toggle-status', [DoctorController::class, 'toggleStatus'])
            ->name('toggleStatus');
    });



    /*
    |--------------------------------------------------------------------------
    | specialty Module
    |--------------------------------------------------------------------------
    */
    Route::prefix('specialty')->name('specialty.')->group(function () {
        Route::get('/', [specialtyController::class, 'index'])->name('index');
        Route::get('/create', [specialtyController::class, 'create'])->name('create');
        Route::post('/', [specialtyController::class, 'store'])->name('store');
        Route::get('/{id}/edit', [specialtyController::class, 'edit'])->name('edit');
        Route::put('/{id}', [specialtyController::class, 'update'])->name('update');
        Route::delete('/{id}', [specialtyController::class, 'destroy'])->name('destroy');
        Route::get('/{id}/doctors', [specialtyController::class, 'doctors'])
            ->name('doctors');
    });
    /*
    |--------------------------------------------------------------------------
    | Services Module
    |--------------------------------------------------------------------------
    */
    Route::prefix('services')->name('services.')->group(function () {
        Route::get('/', [ServiceController::class, 'index'])->name('index');
        Route::get('/create', [ServiceController::class, 'create'])->name('create');
        Route::post('/', [ServiceController::class, 'store'])->name('store');
        Route::get('/{id}/edit', [ServiceController::class, 'edit'])->name('edit');
        Route::put('/{id}', [ServiceController::class, 'update'])->name('update');
        Route::delete('/{id}', [ServiceController::class, 'destroy'])->name('destroy');
        Route::post('/toggle-status/{id}', [ServiceController::class, 'toggleStatus'])
            ->name('toggle-status');


    });



    /*
    |--------------------------------------------------------------------------
    | Treatment Plans Module
    |--------------------------------------------------------------------------
    */
    Route::prefix('treatment-plans')->name('treatment-plans.')->group(function () {
        Route::get('/', [TreatmentPlanController::class, 'index'])->name('index');
        Route::get('/create/{id}', [TreatmentPlanController::class, 'create'])->name('create');
        Route::get('/{id}', [TreatmentPlanController::class, 'show'])->name('show');
        Route::post('/', [TreatmentPlanController::class, 'store'])->name('store');
        Route::delete('/{id}', [TreatmentPlanController::class, 'destroy'])->name('destroy');
        Route::patch('/{id}/status', [TreatmentPlanController::class, 'updateStatus'])
            ->name('update-status');
        // Items
        Route::post('/{plan_id}/items', [TreatmentPlanItemController::class, 'store'])
            ->name('items.store');
        Route::delete('/item/{id}', [TreatmentPlanItemController::class, 'destroy'])
            ->name('items.destroy');
        Route::patch('/item/{id}/status', [TreatmentPlanItemController::class, 'updateStatus'])
            ->name('items.update-status');

    });






    /*
    |--------------------------------------------------------------------------
    | Invoices Module
    |--------------------------------------------------------------------------
    */
        Route::prefix('invoices')->name('invoices.')->group(function () {
        Route::get('/', [InvoiceController::class, 'index'])->name('index');
        Route::get('/create', [InvoiceController::class, 'create'])->name('create');
        Route::get('show/{id}', [InvoiceController::class, 'show'])->name('show');
        Route::post('/', [InvoiceController::class, 'store'])->name('store');
            Route::get('/{id}/edit', [InvoiceController::class, 'edit'])->name('edit');
            Route::put('/{id}', [InvoiceController::class, 'update'])->name('update');
        // print
        Route::get('print/{id}', [InvoiceController::class, 'print'])->name('invoices_print');
            Route::get('/ajax/patient-plans', [InvoiceController::class, 'ajaxPatientPlans'])
                ->name('ajax.plans');

            Route::get('/ajax/plan-items', [InvoiceController::class, 'ajaxPlanItems'])
                ->name('ajax.plan-items');
    });



    /*
    |--------------------------------------------------------------------------
    | Payments
    |--------------------------------------------------------------------------
    */
    Route::prefix('payments')->name('payments.')->group(function () {
        Route::post('/', [PaymentController::class, 'store'])->name('store');
    });



    /*
    |--------------------------------------------------------------------------
    | Inventory / Pharmacy
    |--------------------------------------------------------------------------
    */
    Route::prefix('inventory')->name('inventory.')->group(function () {

        // Items
        Route::prefix('items')->name('items.')->group(function () {
            Route::get('/', [InventoryItemController::class, 'index'])->name('index');
            Route::get('/create', [InventoryItemController::class, 'create'])->name('create');
            Route::post('/', [InventoryItemController::class, 'store'])->name('store');
            Route::get('/{id}/edit', [InventoryItemController::class, 'edit'])->name('edit');
            Route::put('/{id}', [InventoryItemController::class, 'update'])->name('update');
            Route::delete('/{id}', [InventoryItemController::class, 'destroy'])->name('destroy');
            Route::post('/{id}/movement',
                [InventoryItemController::class, 'applyMovement']
            )->name('movement');

        });

        // Movements
        Route::prefix('movements')->name('movements.')->group(function () {
            Route::get('/', [StockMovementController::class, 'index'])->name('index');

        });
    });



    /*
    |--------------------------------------------------------------------------
    | WhatsApp Integration
    |--------------------------------------------------------------------------
    */




    /*
    |--------------------------------------------------------------------------
    | Settings
    |--------------------------------------------------------------------------
    */
    Route::prefix('settings')->name('settings.')->group(function () {

        Route::get('/', [App\Http\Controllers\Settings\SettingController::class, 'index'])
            ->name('general');

        Route::prefix('clinic')->name('clinic.')->group(function () {
            Route::get('/', [ClinicSettingController::class, 'index'])->name('index');
            Route::post('/', [ClinicSettingController::class, 'update'])->name('update');
        });

        Route::prefix('users')->name('users.')->group(function () {
            Route::get('/', [UserController::class, 'index'])->name('index');
            Route::get('/create', [UserController::class, 'create'])->name('create');
            Route::get('/{id}/edit', [UserController::class, 'edit'])->name('edit');
            Route::post('/', [UserController::class, 'store'])->name('store');
            Route::post('/toggle/{id}', [UserController::class, 'toggleActive'])->name('toggle');
            Route::put('/{id}', [UserController::class, 'update'])->name('update');
            Route::delete('/{id}', [UserController::class, 'destroy'])->name('destroy');
        });
    });

});


//Route::get('/dashboard', function () {
//    return view('dashboard');
//})->middleware(['auth', 'verified'])->name('dashboard');
//
//Route::middleware('auth')->group(function () {
//    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
//    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
//    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
//});

require __DIR__.'/auth.php';
