@extends('admin.layouts.master')

@section('title', 'إضافة مستخدم')

@section('content')

    <div class="content-header mb-3">
        <h5>إضافة مستخدم</h5>
    </div>

    <form action="{{ route('settings.users.store') }}" method="POST">
        @csrf

        <div class="card">
            <div class="card-body">

                <div class="row g-3">

                    <div class="col-md-4">
                        <label class="form-label">الاسم *</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">البريد *</label>
                        <input type="email" name="email" class="form-control" required>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">الهاتف</label>
                        <input type="text" name="phone" class="form-control">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">الفرع</label>
                        <select name="branch_id" class="form-select">
                            <option value="">اختر فرع</option>
                            @foreach($branches as $b)
                                <option value="{{ $b->id }}">{{ $b->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">نوع المستخدم *</label>
                        <select name="role" class="form-select" required>
                            <option value="owner">Owner</option>
                            <option value="admin">Admin</option>
                            <option value="doctor">Doctor</option>
                            <option value="receptionist">Receptionist</option>
                            <option value="accountant">Accountant</option>
                            <option value="nurse">Nurse</option>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">كلمة المرور *</label>
                        <input type="password" name="password" class="form-control" required>
                    </div>

                </div>

            </div>
            <div class="card-footer text-end">
                <button class="btn btn-primary">حفظ</button>
            </div>
        </div>

    </form>

@endsection
