@extends('admin.layouts.master')

@section('title', 'الخدمات')
@section('css')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

    <style>
        .switch {
            position: relative;
            display: inline-block;
            width: 46px;
            height: 24px;
        }

        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #dc3545;
            -webkit-transition: .4s;
            transition: .4s;
            border-radius: 24px;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 18px;
            width: 18px;
            left: 3px;
            bottom: 3px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
            border-radius: 50%;
        }

        input:checked + .slider {
            background-color: #28a745;
        }

        input:checked + .slider:before {
            transform: translateX(22px);
        }
    </style>

@endsection
@section('content')

    <div class="content-header mb-3">
        <div class="d-flex justify-content-between align-items-center">
            <h5 class="mb-0">الخدمات الطبية</h5>

            <a href="{{ route('services.create') }}" class="btn btn-sm btn-primary">
                <i class="ti ti-plus"></i> إضافة خدمة جديدة
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-12">

            <div class="card table-card">
                <div class="card-header">
                    <h6 class="mb-0">قائمة الخدمات</h6>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table" id="pc-dt-simple">
                            <thead>
                            <tr>
                                <th class="text-start">#</th>
                                <th class="text-start">اسم الخدمة</th>
                                <th class="text-start">التخصص</th>
                                <th class="text-start">العيادة</th>
                                <th class="text-start">التصنيف</th>
                                <th class="text-start">السعر الافتراضي</th>
                                <th class="text-start">المدة (دقيقة)</th>
                                <th class="text-start">الحالة</th>
                                <th class="text-center">العمليات</th>
                            </tr>
                            </thead>

                            <tbody>
                            @forelse($services as $service)
                                <tr>
                                    <td>{{ $service->id }}</td>

                                    <td>{{ $service->name }}</td>

                                    <td>{{ $service->specialty?->name ?? '-' }}</td>

                                    <td>{{ $service->clinic?->name ?? '-' }}</td>

                                    <td>{{ $service->category ?? '-' }}</td>

                                    <td>
                                        {{ number_format($service->default_price, 2) }}
                                        <small class="text-muted"> <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="20" height="20" alt=""></small>
                                    </td>

                                    <td>
                                        {{ $service->duration_minutes ? $service->duration_minutes . ' دقيقة' : '-' }}
                                    </td>

                                    <td class="text-center">
                                        <label class="switch">
                                            <input type="checkbox"
                                                   class="toggle-status"
                                                   data-id="{{ $service->id }}"
                                                {{ $service->is_active ? 'checked' : '' }}>
                                            <span class="slider round"></span>
                                        </label>
                                    </td>


                                    <td class="text-center">

                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="{{ route('services.edit', $service->id) }}"
                                               class="btn  btn-sm btn-success">
                                                <i class="fa fa-edit"></i>
                                            </a>

                                            <form action="{{ route('services.destroy', $service->id) }}"
                                                  method="POST"
                                                  onsubmit="return confirm('هل أنت متأكد من حذف هذه الخدمة؟');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>

                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="9" class="text-center text-muted">
                                        لا توجد خدمات مسجلة حتى الآن.
                                    </td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>

        </div>
    </div>

@endsection

@section('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script>
        $(document).on('change', '.toggle-status', function () {
            let id = $(this).data('id');

            $.ajax({
                url: "{{ url('/services/toggle-status') }}/" + id,
                type: 'POST',
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function (res) {
                    toastr.success("تم تحديث حالة الخدمة إلى: " + res.status, "نجاح");
                },
                error: function () {
                    toastr.error("حدث خطأ، حاول مرة أخرى", "خطأ");
                }
            });
        });
    </script>
@endsection

