@extends('admin.layouts.master')
@section('css')

@endsection

@section('title')
    عرض بيانات العميل
@endsection

@section('content')

    <div class="content-header">
        <h5>تعديل بيانات المريض</h5>

    </div>

    <div class="row gy-4">

        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">بيانات المريض</h5>
                    <a href="{{ route('patients.edit', $patient->id) }}" class="btn btn-sm btn-primary">
                        تعديل بيانات المريض
                    </a>
                </div>
                <div class="card-body">

                    <div class="row gy-3">

                        <div class="col-md-3">
                            <label class="fw-bold">كود المريض:</label>
                            <div>{{ $patient->code }}</div>
                        </div>

                        <div class="col-md-3">
                            <label class="fw-bold">الاسم:</label>
                            <div>{{ $patient->first_name }} {{ $patient->last_name }}</div>
                        </div>

                        <div class="col-md-3">
                            <label class="fw-bold">الهاتف:</label>
                            <div>{{ $patient->phone }}</div>
                        </div>

                        <div class="col-md-3">
                            <label class="fw-bold">هاتف إضافي:</label>
                            <div>{{ $patient->phone_alt ?: '-' }}</div>
                        </div>

                        <div class="col-md-3">
                            <label class="fw-bold">الجنس:</label>
                            <div>
                                @if($patient->gender === 'male')
                                    ذكر
                                @elseif($patient->gender === 'female')
                                    أنثى
                                @else
                                    -
                                @endif
                            </div>
                        </div>

                        <div class="col-md-3">
                            <label class="fw-bold">تاريخ الميلاد:</label>
                            <div>{{ $patient->birth_date ?: '-' }}</div>
                        </div>

                        <div class="col-md-6">
                            <label class="fw-bold">العنوان:</label>
                            <div>{{ $patient->address ?: '-' }}</div>
                        </div>

                        <div class="col-md-12">
                            <label class="fw-bold">ملاحظات:</label>
                            <div>{{ $patient->notes ?: '-' }}</div>
                        </div>

                    </div>

                    @if($patient->medicalRecord)
                        <hr>
                        <h6 class="fw-bold mb-3">الملف الطبي</h6>
                        <div class="row gy-2">
                            <div class="col-md-3">
                                <label class="fw-bold">فصيلة الدم:</label>
                                <div>{{ $patient->medicalRecord->blood_type ?: '-' }}</div>
                            </div>
                            <div class="col-md-9">
                                <label class="fw-bold">الحساسية من أدوية:</label>
                                <div>{{ $patient->medicalRecord->allergies ?: '-' }}</div>
                            </div>
                            <div class="col-md-12">
                                <label class="fw-bold">أمراض مزمنة:</label>
                                <div>{{ $patient->medicalRecord->chronic_diseases ?: '-' }}</div>
                            </div>
                        </div>
                    @endif

                </div>
            </div>
        </div>

        <div class="col-lg-12">
            <div class="card h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">المواعيد</h5>
                </div>
                <div class="card-body">

                    {{-- فورم حجز موعد جديد للمريض --}}
                    {{-- فورم حجز موعد جديد للمريض --}}
                    <form action="{{ route('patients.attachments.store') }}" method="POST" class="mb-4">
                        @csrf
                        <input type="hidden" name="form_type" value="appointment">
                        <input type="hidden" name="patient_id" value="{{ $patient->id }}">

                        <div class="row g-2 align-items-end">
                            <div class="col-md-5">
                                <label class="form-label">التاريخ *</label>
                                <input type="date" name="appointment_date" class="form-control" required>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">الوقت *</label>
                                <input type="time" name="start_time" class="form-control" required>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">الطبيب *</label>
                                <select name="doctor_id" class="form-select" required>
                                    <option value="">اختر طبيب</option>
                                    @foreach($doctors as $doctor)
                                        <option value="{{ $doctor->id }}">
                                            {{ $doctor->user->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <button class="btn btn-sm btn-primary mt-3">
                            حجز الموعد
                        </button>
                    </form>

                    {{-- جدول المواعيد --}}
                    <div class="table-responsive">
                        <table class="table table-sm table-striped">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>التاريخ</th>
                                <th>الوقت</th>
                                <th>الطبيب</th>
                                <th>الحالة</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($patient->appointments->sortByDesc('appointment_date') as $appointment)
                                <tr>
                                    <td>{{ $appointment->id }}</td>
                                    <td>{{ $appointment->appointment_date }}</td>
                                    <td>{{ $appointment->start_time }}</td>
                                    <td>{{ $appointment->doctor?->user?->name }}</td>
                                    <td>{{ $appointment->status }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center">لا توجد مواعيد مسجلة لهذا المريض.</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>

        <div class="col-lg-12">
            <div class="card h-100">

                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">إضافة زيارة جديدة للمريض</h5>
                </div>

                <div class="card-body">

                    <form action="{{ route('patients.attachments.store') }}" method="POST">
                        @csrf
                        <input type="hidden" name="form_type" value="visit">
                        <input type="hidden" name="patient_id" value="{{ $patient->id }}">

                        <div class="row g-2">
                            <div class="col-md-4">
                                <label class="form-label">تاريخ الزيارة *</label>
                                <input type="date" name="visit_date" class="form-control" required
                                       value="{{ now()->toDateString() }}">
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">الطبيب *</label>
                                <select name="doctor_id" class="form-control" required>
                                    <option value="">اختر طبيب</option>
                                    @foreach($doctors as $doctor)
                                        <option value="{{ $doctor->id }}">
                                            {{ $doctor->user->name }} ({{ $doctor->specialty->name }})
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-md-12 mt-2">
                                <label class="form-label">الشكوى / سبب الزيارة</label>
                                <input type="text" name="chief_complaint" class="form-control"
                                       placeholder="مثال: ألم في الجانب الأيمن من البطن / ألم ضرس علوي يمين">
                            </div>

                            <div class="col-md-12 mt-2">
                                <label class="form-label">ملاحظات عامة للطبيب (اختياري)</label>
                                <textarea name="notes" rows="2" class="form-control"></textarea>
                            </div>
                        </div>

                        <button class="btn btn-sm btn-outline-success mt-2">
                            حفظ الزيارة
                        </button>
                    </form>
                </div>


            </div>

        </div>

        {{-- خطط العلاج --}}
        <div class="col-12">
            <div class="card h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">خطط العلاج</h5>

                    <a href="{{ route('treatment-plans.create', $patient->id) }}"
                       class="btn btn-sm btn-success">
                        إضافة خطة علاج جديدة
                    </a>
                </div>

                <div class="card-body">
                    @if($patient->treatmentPlans?->count())
                        <div class="table-responsive">
                            <table class="table table-sm table-striped align-middle">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العنوان</th>
                                    <th>الطبيب</th>
                                    <th>الحالة</th>
                                    <th>تاريخ الإنشاء</th>
                                    <th>إجراءات</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($patient->treatmentPlans as $plan)
                                    @php
                                        $status = $plan->status;
                                        $badgeClass = match($status) {
                                            'draft'    => 'secondary',
                                            'ongoing'  => 'warning',
                                            'completed'=> 'success',
                                            'cancelled'=> 'danger',
                                            default    => 'secondary',
                                        };
                                    @endphp
                                    <tr>
                                        <td>{{ $plan->id }}</td>
                                        <td>{{ $plan->title ?? '-' }}</td>
                                        <td>{{ $plan->doctor?->user?->name ?? '-' }}</td>
                                        <td>
                                    <span class="badge bg-{{ $badgeClass }}">
                                        {{ $plan->status }}
                                    </span>
                                        </td>
                                        <td>{{ $plan->created_at?->format('Y-m-d') }}</td>
                                        <td>
                                            <a href="{{ route('treatment-plans.show', $plan->id) }}"
                                               class="btn btn-sm btn-outline-primary">
                                                عرض الخطة
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <p class="text-center text-muted mb-0">
                            لا توجد خطط علاج لهذا المريض.
                        </p>
                    @endif
                </div>
            </div>
        </div>



        <div class="col-lg-12">
            <div class="card h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">الروشتات الطبية</h5>
                </div>
                <div class="card-body">

                    {{-- فورم روشتة جديدة (سريعة) --}}

                    <form action="{{ route('patients.attachments.store') }}" method="POST" class="mb-4">
                        @csrf
                        <input type="hidden" name="form_type" value="prescription">
                        <input type="hidden" name="patient_id" value="{{ $patient->id }}">

                        @if($patient->visits->count())
                            <div class="mb-2">
                                <label class="form-label">الزيارة المرتبطة</label>
                                <select name="visit_id" class="form-select" required>
                                    <option value="">بدون</option>
                                    @foreach($patient->visits->sortByDesc('visit_date') as $visit)
                                        <option value="{{ $visit->id }}">
                                            زيارة رقم {{ $visit->id }} - {{ $visit->visit_date }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        @endif



                        <div class="mb-2">
                            <label class="form-label">ملاحظات الروشتة / التعليمات</label>
                            <textarea name="notes" id="classic-editor" rows="5" class="form-control"
                                      placeholder="اكتب ملاحظات الطبيب أو التعليمات العامة للمريض"></textarea>
                        </div>

                        <button class="btn btn-sm btn-primary mt-1">
                            حفظ الروشتة
                        </button>
                    </form>


                    {{-- جدول كل الروشتات السابقة --}}
                    <div class="prescriptions-list">

                        @forelse($patient->prescriptions->sortByDesc('created_at') as $prescription)
                            <div class="card mb-3 shadow-sm">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <div>
                                        <strong>روشتة رقم #{{ $prescription->id }}</strong><br>
                                        <small class="text-muted">
                                            {{ $prescription->created_at->format('Y-m-d H:i') }}
                                            —
                                            د. {{ $prescription->doctor?->user?->name }}
                                        </small>
                                    </div>

                                    <div class="d-flex gap-1">
                                        <button class="btn btn-sm btn-outline-primary"
                                                onclick="document.getElementById('rx-{{ $prescription->id }}').classList.toggle('d-none')">
                                            عرض التفاصيل
                                        </button>

                                        <a href="{{ route('patients.prescriptions.print', $prescription->id) }}"
                                           target="_blank"
                                           class="btn btn-sm btn-secondary">
                                            طباعة
                                        </a>
                                    </div>
                                </div>


                                <div class="card-body d-none" id="rx-{{ $prescription->id }}">
                                    <div class="rx-text">
                                        {!!$prescription->notes !!}
                                    </div>

                                    {{-- لو فيه items وادوية --}}
                                    @if($prescription->items->count())
                                        <hr>
                                        <h6 class="fw-bold">الأدوية:</h6>
                                        <ul class="list-group">
                                            @foreach($prescription->items as $item)
                                                <li class="list-group-item">
                                                    <strong>{{ $item->medication->name ?? '—' }}</strong><br>
                                                    <small class="text-muted">{{ $item->instructions }}</small>
                                                </li>
                                            @endforeach
                                        </ul>
                                    @endif
                                </div>
                            </div>

                        @empty
                            <div class="alert alert-warning text-center">
                                لا توجد روشتات مسجلة لهذا المريض.
                            </div>
                        @endforelse

                    </div>

                </div>
            </div>
        </div>

        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">فواتير المريض</h5>

                    <a href="{{ route('invoices.index') }}" class="btn btn-sm btn-outline-secondary">
                        كل الفواتير
                    </a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm table-striped align-middle">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>رقم الفاتورة</th>
                                <th>التاريخ</th>
                                <th class="text-end">الإجمالي</th>
                                <th class="text-end">المدفوع</th>
                                <th class="text-end">المتبقي</th>
                                <th>الحالة</th>
                                <th>دفع</th>
                                <th>عرض</th>
                            </tr>
                            </thead>
                            <tbody>
                            @php $i = 1; @endphp
                            @forelse($patient->invoices as $invoice)
                                @php
                                    $remaining = max($invoice->total - $invoice->paid_amount, 0);
                                @endphp
                                <tr>
                                    <td>{{ $i++ }}</td>
                                    <td>{{ $invoice->invoice_number }}</td>
                                    <td>{{ $invoice->date->format('Y-m-d') }}</td>
                                    <td class="text-end">
                                        {{ number_format($invoice->total, 2) }}
                                        <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="14" height="14" alt="">
                                    </td>
                                    <td class="text-end">
                                        {{ number_format($invoice->paid_amount, 2) }}
                                        <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="14" height="14" alt="">
                                    </td>
                                    <td class="text-end">
                                        {{ number_format($remaining, 2) }}
                                        <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="14" height="14" alt="">
                                    </td>
                                    <td>
                                        @switch($invoice->status)
                                            @case('unpaid')
                                                <span class="badge bg-danger">غير مدفوعة</span>
                                                @break
                                            @case('partial')
                                                <span class="badge bg-warning text-dark">مدفوعة جزئياً</span>
                                                @break
                                            @case('paid')
                                                <span class="badge bg-success">مدفوعة بالكامل</span>
                                                @break
                                            @case('refunded')
                                                <span class="badge bg-secondary">مسترجعة</span>
                                                @break
                                        @endswitch
                                    </td>

                                    <td>
                                        @if($remaining > 0)
                                            <form action="{{ route('payments.store') }}" method="POST"
                                                  class="d-flex gap-1 align-items-center">
                                                @csrf
                                                <input type="hidden" name="invoice_id" value="{{ $invoice->id }}">

                                                <input type="number" step="0.01" min="0.01"
                                                       max="{{ $remaining }}"
                                                       name="amount"
                                                       class="form-control form-control-sm"
                                                       style="max-width: 110px"
                                                       value="{{ $remaining }}">

                                                <select name="payment_method"
                                                        class="form-select form-select-sm"
                                                        style="max-width: 110px">
                                                    <option value="cash">كاش</option>
                                                    <option value="card">بطاقة</option>
                                                    <option value="bank_transfer">تحويل</option>
                                                    <option value="online">أونلاين</option>
                                                </select>

                                                <button type="submit" class="btn btn-sm btn-success">
                                                    دفع
                                                </button>
                                            </form>
                                        @else
                                            <span class="text-success">لا يوجد متبقي</span>
                                        @endif
                                    </td>

                                    <td>
                                        <a href="{{ route('invoices.show', $invoice->id) }}"
                                           class="btn btn-sm btn-outline-primary">
                                            عرض
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="9" class="text-center text-muted">
                                        لا توجد فواتير لهذا المريض حتى الآن.
                                    </td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>



        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">الملفات والمرفقات</h5>
                </div>
                <div class="card-body">


                    <form action="{{ route('patients.attachments.store') }}" method="POST"
                          enctype="multipart/form-data" class="mb-4">
                        @csrf
                        <input type="hidden" name="form_type" value="attachment">
                        <input type="hidden" name="patient_id" value="{{ $patient->id }}">

                        <div class="row g-2 align-items-end">
                            <div class="col-md-4">
                                <label class="form-label">الملف *</label>
                                <input type="file" name="file" class="form-control" required>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">نوع الملف</label>
                                <input type="text" name="file_type" class="form-control"
                                       placeholder="أشعة، تحاليل، تقرير...">
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">وصف</label>
                                <input type="text" name="description" class="form-control">
                            </div>
                        </div>

                        <button class="btn btn-sm btn-primary mt-3">
                            رفع المرفق
                        </button>
                    </form>


                    {{-- جدول المرفقات --}}
                    <div class="table-responsive">
                        <table class="table table-sm table-striped">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>الملف</th>
                                <th>النوع</th>
                                <th>الوصف</th>
                                <th>التاريخ</th>
                                <th>إجراءات</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($patient->attachments->sortByDesc('created_at') as $attachment)
                                <tr>
                                    <td>{{ $attachment->id }}</td>
                                    <td>
                                        <a href="{{ asset($attachment->file_path) }}" target="_blank">
                                            عرض الملف
                                        </a>
                                    </td>
                                    <td>{{ $attachment->file_type ?: '-' }}</td>
                                    <td>{{ $attachment->description ?: '-' }}</td>
                                    <td>{{ $attachment->created_at->format('Y-m-d H:i') }}</td>
                                    <td>
                                        <form action="{{ route('patients.attachments.destroy', $attachment->id) }}"
                                              method="POST"
                                              onsubmit="return confirm('حذف هذا المرفق؟');">
                                            @csrf
                                            @method('DELETE')
                                            <button class="btn btn-sm btn-danger">
                                                حذف
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="text-center">لا توجد مرفقات لهذا المريض.</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script src="{{asset('dash/assets/js/plugins/ckeditor/classic/ckeditor.js')}}"></script>
    <script type="text/javascript">
        (function () {
            ClassicEditor.create(document.querySelector('#classic-editor'))
                .catch(error => {
                    console.error(error);
                });
        })();
    </script>
@endsection
