@extends('admin.layouts.master')

@section('title', 'عرض الفاتورة #' . $invoice->invoice_number)

@section('content')

    <div class="content-header d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">فاتورة رقم: {{ $invoice->invoice_number }}</h5>

        <div class="d-flex gap-2">
            <a href="{{ route('invoices.invoices_print', $invoice->id) }}" target="_blank" class="btn btn-sm btn-secondary">
                طباعة الفاتورة
            </a>

            @if($invoice->patient)
                <a href="{{ route('patients.show', $invoice->patient->id) }}" class="btn btn-sm btn-outline-primary">
                    ملف المريض
                </a>
            @endif

            <a href="{{ route('invoices.index') }}" class="btn btn-sm btn-outline-dark">
                كل الفواتير
            </a>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    <div class="row gy-4">

        {{-- بيانات أساسية --}}
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">بيانات الفاتورة</h6>
                </div>
                <div class="card-body">

                    <div class="row gy-2">
                        <div class="col-md-6">
                            <strong>رقم الفاتورة:</strong>
                            <div>{{ $invoice->invoice_number }}</div>
                        </div>

                        <div class="col-md-6">
                            <strong>التاريخ:</strong>
                            <div>{{ $invoice->date->format('Y-m-d') }}</div>
                        </div>

                        <div class="col-md-6">
                            <strong>المريض:</strong>
                            <div>
                                {{ $invoice->patient?->first_name }} {{ $invoice->patient?->last_name }}
                                @if($invoice->patient?->code)
                                    <small class="text-muted">({{ $invoice->patient->code }})</small>
                                @endif
                            </div>
                        </div>

                        <div class="col-md-6">
                            <strong>الحالة:</strong>
                            <div>
                                @switch($invoice->status)
                                    @case('unpaid')
                                        <span class="badge bg-danger">غير مدفوعة</span>
                                        @break
                                    @case('partial')
                                        <span class="badge bg-warning text-dark">مدفوعة جزئياً</span>
                                        @break
                                    @case('paid')
                                        <span class="badge bg-success">مدفوعة بالكامل</span>
                                        @break
                                    @case('refunded')
                                        <span class="badge bg-secondary">مسترجعة</span>
                                        @break
                                @endswitch
                            </div>
                        </div>

                        <div class="col-md-6">
                            <strong>الإجمالي الكلي:</strong>
                            <div>
                                {{ number_format($invoice->total, 2) }}
                                <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="16" height="16" alt="">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <strong>المدفوع:</strong>
                            <div>
                                {{ number_format($invoice->paid_amount, 2) }}
                                <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="16" height="16" alt="">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <strong>المتبقي:</strong>
                            <div>
                                {{ number_format($remaining, 2) }}
                                <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="16" height="16" alt="">
                            </div>
                        </div>

                        @if($invoice->payment_due_date)
                            <div class="col-md-6">
                                <strong>تاريخ الاستحقاق:</strong>
                                <div>{{ $invoice->payment_due_date->format('Y-m-d') }}</div>
                            </div>
                        @endif
                    </div>

                </div>
            </div>
        </div>

        {{-- بنود الفاتورة --}}
        <div class="col-lg-6">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">بنود الفاتورة</h6>
                </div>
                <div class="card-body">

                    <div class="table-responsive">
                        <table class="table table-sm table-striped align-middle">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>الوصف</th>
                                <th class="text-center">الكمية</th>
                                <th class="text-end">سعر الوحدة</th>
                                <th class="text-end">الخصم</th>
                                <th class="text-end">الإجمالي</th>
                            </tr>
                            </thead>
                            <tbody>
                            @php
                                $row = 1;
                            @endphp
                            @foreach($invoice->items as $item)
                                <tr>
                                    <td>{{ $row++ }}</td>
                                    <td>
                                        {{ $item->description }}
                                        @if($item->service)
                                            <br>
                                            <small class="text-muted">
                                                (خدمة: {{ $item->service->name }})
                                            </small>
                                        @endif
                                    </td>
                                    <td class="text-center">{{ $item->quantity }}</td>
                                    <td class="text-end">
                                        {{ number_format($item->unit_price, 2) }}
                                        <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="14" height="14" alt="">
                                    </td>
                                    <td class="text-end">
                                        {{ number_format($item->discount, 2) }}
                                        <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="14" height="14" alt="">
                                    </td>
                                    <td class="text-end">
                                        {{ number_format($item->line_total, 2) }}
                                        <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="14" height="14" alt="">
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                            <tfoot>
                            <tr>
                                <th colspan="5" class="text-end">الإجمالي قبل الخصم</th>
                                <th class="text-end">
                                    {{ number_format($invoice->subtotal, 2) }}
                                    <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="14" height="14" alt="">
                                </th>
                            </tr>
                            <tr>
                                <th colspan="5" class="text-end">إجمالي الخصم</th>
                                <th class="text-end">
                                    {{ number_format($invoice->discount, 2) }}
                                    <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="14" height="14" alt="">
                                </th>
                            </tr>
                            <tr>
                                <th colspan="5" class="text-end">
                                    الضريبة ({{ number_format($invoice->tax_percent, 2) }}%)
                                </th>
                                <th class="text-end">
                                    {{ number_format($invoice->tax_amount, 2) }}
                                    <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="14" height="14" alt="">
                                </th>
                            </tr>
                            <tr>
                                <th colspan="5" class="text-end fw-bold">الإجمالي النهائي</th>
                                <th class="text-end fw-bold">
                                    {{ number_format($invoice->total, 2) }}
                                    <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="14" height="14" alt="">
                                </th>
                            </tr>
                            </tfoot>
                        </table>
                    </div>

                </div>
            </div>
        </div>

        {{-- المدفوعات + دفع المتبقي --}}
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="mb-0">المدفوعات على الفاتورة</h6>

                    @if($remaining > 0)
                        <span class="badge bg-warning text-dark">
                            المتبقي: {{ number_format($remaining, 2) }}
                            <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="14" height="14" alt="">
                        </span>
                    @else
                        <span class="badge bg-success">لا يوجد متبقي</span>
                    @endif
                </div>
                <div class="card-body">

                    {{-- جدول المدفوعات السابقة --}}
                    <div class="table-responsive mb-3">
                        <table class="table table-sm table-striped align-middle">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>التاريخ</th>
                                <th>المبلغ</th>
                                <th>طريقة الدفع</th>
                                <th>رقم العملية</th>
                                <th>ملاحظات</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($invoice->payments->sortBy('paid_at') as $pay)
                                <tr>
                                    <td>{{ $pay->id }}</td>
                                    <td>{{ $pay->paid_at->format('Y-m-d H:i') }}</td>
                                    <td>
                                        {{ number_format($pay->amount, 2) }}
                                        <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="14" height="14" alt="">
                                    </td>
                                    <td>
                                        @switch($pay->payment_method)
                                            @case('cash') كاش @break
                                            @case('card') بطاقة @break
                                            @case('bank_transfer') تحويل بنكي @break
                                            @case('online') أونلاين @break
                                        @endswitch
                                    </td>
                                    <td>{{ $pay->transaction_id ?: '-' }}</td>
                                    <td>{{ $pay->notes ?: '-' }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="text-center text-muted">
                                        لا توجد مدفوعات مسجلة على هذه الفاتورة.
                                    </td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>

                    {{-- فورم دفع المتبقي --}}
                    @if($remaining > 0)
                        <form action="{{ route('payments.store') }}" method="POST" class="row g-2 align-items-end">
                            @csrf
                            <input type="hidden" name="invoice_id" value="{{ $invoice->id }}">

                            <div class="col-md-3">
                                <label class="form-label">المتبقي الحالي</label>
                                <input type="text" class="form-control" value="{{ number_format($remaining, 2) }}"
                                       disabled>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">المبلغ المراد دفعه *</label>
                                <input type="number" step="0.01" min="0.01"
                                       max="{{ $remaining }}"
                                       name="amount"
                                       class="form-control"
                                       value="{{ $remaining }}" required>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">طريقة الدفع *</label>
                                <select name="payment_method" class="form-select" required>
                                    <option value="cash">كاش</option>
                                    <option value="card">بطاقة</option>
                                    <option value="bank_transfer">تحويل بنكي</option>
                                    <option value="online">أونلاين</option>
                                </select>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">رقم العملية (اختياري)</label>
                                <input type="text" name="transaction_id" class="form-control">
                            </div>

                            <div class="col-md-12 mt-2">
                                <label class="form-label">ملاحظات (اختياري)</label>
                                <textarea name="notes" rows="2" class="form-control"></textarea>
                            </div>

                            <div class="col-12 text-end mt-2">
                                <button type="submit" class="btn btn-success">
                                    تسجيل دفعة
                                </button>
                            </div>
                        </form>
                    @endif

                </div>
            </div>
        </div>

    </div>

@endsection
