<?php

namespace Database\Seeders;

use App\Models\Services;
use App\Models\TreatmentPlanItems;
use App\Models\TreatmentPlans;
use App\Models\Visits;
use Illuminate\Database\Seeder;


class TreatmentPlanItemSeeder extends Seeder
{
    public function run(): void
    {
        $plan   = TreatmentPlans::first();
        $visit  = Visits::first();

        $consult = Services::where('name', 'Dental Consultation')->first();
        $clean   = Services::where('name', 'Teeth Cleaning')->first();
        $filling = Services::where('name', 'Tooth Filling')->first();

        // Consultation
        TreatmentPlanItems::create([
            'treatment_plan_id' => $plan->id,
            'service_id'        => $consult?->id,
            'visit_id'          => $visit?->id,
            'quantity'          => 1,
            'price'             => 200,
            'discount'          => 0,
            'status'            => 'done',
            'notes'             => 'Initial consultation completed.',
        ]);

        // Cleaning
        TreatmentPlanItems::create([
            'treatment_plan_id' => $plan->id,
            'service_id'        => $clean?->id,
            'visit_id'          => null,
            'quantity'          => 1,
            'price'             => 400,
            'discount'          => 0,
            'status'            => 'planned',
            'notes'             => 'Schedule for next visit.',
        ]);

        // Filling
        TreatmentPlanItems::create([
            'treatment_plan_id' => $plan->id,
            'service_id'        => $filling?->id,
            'visit_id'          => null,
            'tooth_number'      => '26',
            'surface'           => 'MO',
            'quantity'          => 1,
            'price'             => 600,
            'discount'          => 50,
            'status'            => 'planned',
            'notes'             => 'Filling required due to cavity.',
        ]);
    }
}
