<?php

namespace Database\Seeders;

use App\Models\Branches;
use App\Models\InventoryItems;
use App\Models\StockMovements;
use Illuminate\Database\Seeder;

class StockMovementSeeder extends Seeder
{
    public function run(): void
    {
        $branch = Branches::first();
        $items  = InventoryItems::all();

        foreach ($items as $item) {
            StockMovements::create([
                'inventory_item_id' => $item->id,
                'branch_id'         => $branch->id,
                'type'              => 'in',
                'quantity'          => $item->current_quantity,
                'reason'            => 'Initial stock',
                'reference_type'    => null,
                'reference_id'      => null,
            ]);
        }
    }
}
