<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('prescription_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('prescription_id')->constrained('prescriptions')->cascadeOnDelete()->cascadeOnUpdate();
            $table->foreignId('medication_id')->nullable()->constrained('medications')->nullOnDelete()->cascadeOnUpdate();
            $table->string('dose')->nullable();       // قرص مرتين يوميا
            $table->string('frequency')->nullable();  // every 8 hours
            $table->string('duration')->nullable();   // 5 days
            $table->text('instructions')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('prescription_items');
    }
};
