<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TreatmentPlans extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'patient_id',
        'doctor_id',
        'title',
        'description',
        'status',
    ];

    public function patient()
    {
        return $this->belongsTo(Patients::class, 'patient_id');
    }

    public function doctor()
    {
        return $this->belongsTo(DoctorProfiles::class, 'doctor_id');
    }

    public function items()
    {
        return $this->hasMany(TreatmentPlanItems::class, 'treatment_plan_id');
    }

    public function invoice()
    {
        return $this->hasOne(Invoices::class, 'treatment_plan_id');
    }
}
