<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TreatmentPlanItems extends Model
{
    use HasFactory;

    protected $fillable = [
        'treatment_plan_id',
        'service_id',
        'visit_id',
        'tooth_number',
        'surface',
        'quantity',
        'price',
        'discount',
        'status',
        'notes',
    ];

    public function treatmentPlan()
    {
        return $this->belongsTo(TreatmentPlans::class, 'treatment_plan_id');
    }

    public function service()
    {
        return $this->belongsTo(Services::class, 'service_id');
    }

    public function visit()
    {
        return $this->belongsTo(Visits::class, 'visit_id');
    }
}
