<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Specialties extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
    ];

    public function doctorProfiles()
    {
        return $this->hasMany(DoctorProfiles::class, 'specialty_id');
    }

    public function services()
    {
        return $this->hasMany(Services::class, 'specialty_id');
    }
}
