<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Patients extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'clinic_id',
        'branch_id',
        'code',
        'first_name',
        'last_name',
        'gender',
        'birth_date',
        'phone',
        'phone_alt',
        'email',
        'national_id',
        'address',
        'notes',
    ];



    public function clinic()
    {
        return $this->belongsTo(Clinic::class, 'clinic_id');
    }

    public function branch()
    {
        return $this->belongsTo(Branches::class, 'branch_id');
    }

    public function medicalRecord()
    {
        return $this->hasOne(MedicalRecords::class, 'patient_id');
    }

    public function appointments()
    {
        return $this->hasMany(Appointment::class, 'patient_id');
    }

    public function visits()
    {
        return $this->hasMany(Visits::class, 'patient_id');
    }

    public function treatmentPlans()
    {
        return $this->hasMany(TreatmentPlans::class, 'patient_id');
    }

    public function prescriptions()
    {
        return $this->hasMany(Prescriptions::class, 'patient_id');
    }

    public function invoices()
    {
        return $this->hasMany(Invoices::class, 'patient_id');
    }

    public function attachments()
    {
        return $this->hasMany(Attachments::class, 'patient_id');
    }
}
