<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InventoryItems extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'clinic_id',
        'name',
        'category',
        'unit',
        'sku',
        'min_quantity',
        'current_quantity',
        'purchase_price',
        'sale_price',
    ];

    public function clinic()
    {
        return $this->belongsTo(Clinic::class, 'clinic_id');
    }

    public function stockMovements()
    {
        return $this->hasMany(StockMovements::class, 'inventory_item_id');
    }

}
