<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DoctorProfiles extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'user_id',
        'specialty_id',
        'branch_id',
        'title',
        'bio',
        'consultation_fee',
        'followup_fee',
        'commission_type',
        'commission_value',
        'is_accepting_appointments',
    ];

    protected $casts = [
        'is_accepting_appointments' => 'boolean',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function specialty()
    {
        return $this->belongsTo(Specialties::class, 'specialty_id');
    }

    public function branch()
    {
        return $this->belongsTo(Branches::class, 'branch_id');
    }

    public function appointments()
    {
        return $this->hasMany(Appointment::class, 'doctor_id');
    }

    public function visits()
    {
        return $this->hasMany(Visits::class, 'doctor_id');
    }

    public function treatmentPlans()
    {
        return $this->hasMany(TreatmentPlans::class, 'doctor_id');
    }

    public function prescriptions()
    {
        return $this->hasMany(Prescriptions::class, 'doctor_id');
    }
}
