<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Branches extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'clinic_id',
        'name',
        'phone',
        'city',
        'address',
        'is_active',
    ];

    public function clinic()
    {
        return $this->belongsTo(Clinic::class, 'clinic_id');
    }

    public function users()
    {
        return $this->hasMany(User::class, 'branch_id');
    }

    public function patients()
    {
        return $this->hasMany(Patients::class, 'branch_id');
    }

    public function appointments()
    {
        return $this->hasMany(Appointment::class, 'branch_id');
    }

    public function visits()
    {
        return $this->hasMany(Visits::class, 'branch_id');
    }

    public function stockMovements()
    {
        return $this->hasMany(StockMovements::class, 'branch_id');
    }

    public function invoices()
    {
        return $this->hasMany(Invoices::class, 'branch_id');
    }
}
