<?php

namespace App\Http\Controllers\Concerns;

use Throwable;

trait ApiResponder
{
    protected function ok($data, int $status = 200, string $message = 'Success', ?string $opTxn = null)
    {
        return response()->json([
            'status' => $status,
            'message' => $message,
            'response' => $data,
       
        ], $status);
    }

    protected function fail(Throwable $e, int $status = 500, string $message = 'Failed')
    {
        return response()->json([
            'status' => $status,
            'message' => $message,
            'error' => [
                'type' => class_basename($e),
                'message' => $e->getMessage(),
            ],
        ], $status);
    }
}
