<?php

namespace App\Http\Controllers\Api;

use App\Services\RbMockService;
use Illuminate\Http\Request;
use App\Http\Controllers\Concerns\ApiResponder;
use App\Http\Controllers\Controller;

class RbMockController extends Controller
{
    use ApiResponder;

    public function roughOffer(Request $r, RbMockService $svc)
    {
        try {
            $resp = $svc->offerRoughOffer($r->all() ?: null);
            return $this->ok($resp);
        } catch (\Throwable $e) {
            return $this->fail($e);
        }
    }

    public function inquiry(Request $r, RbMockService $svc)
    {
        try {
            $resp = $svc->offerInquiry($r->all() ?: null);
            return $this->ok($resp);
        } catch (\Throwable $e) {
            return $this->fail($e);
        }
    }

    public function export(Request $r, RbMockService $svc)
    {
        try {
            $resp = $svc->offerExport($r->all() ?: null);
            return $this->ok($resp);
        } catch (\Throwable $e) {
            return $this->fail($e);
        }
    }

    public function initialOffer(Request $r, RbMockService $svc)
    {
        try {
            $resp = $svc->offerInitialOffer($r->all() ?: null);
            return $this->ok($resp);
        } catch (\Throwable $e) {
            return $this->fail($e);
        }
    }

    public function decideInitialOffer(string $offerId, Request $r, RbMockService $svc)
    {
        try {
            $resp = $svc->offerDecideInitialOffer($offerId, $r->all() ?: null);
            return $this->ok($resp);
        } catch (\Throwable $e) {
            return $this->fail($e);
        }
    }

    public function finalOfferDecision(string $offerId, Request $r, RbMockService $svc)
    {
        try {
            $resp = $svc->offerFinalOfferDecision($offerId, $r->all() ?: null);
            return $this->ok($resp);
        } catch (\Throwable $e) {
            return $this->fail($e);
        }
    }

    public function cancelOffer(string $offerId, Request $r, RbMockService $svc)
    {
        try {
            $resp = $svc->offerCancel($offerId, $r->all() ?: null);
            return $this->ok($resp);
        } catch (\Throwable $e) {
            return $this->fail($e);
        }
    }

    public function status(string $offerId, RbMockService $svc)
    {
        try {
            $resp = $svc->offerStatus($offerId);
            return $this->ok($resp);
        } catch (\Throwable $e) {
            return $this->fail($e);
        }
    }
}
