<?php

use App\Http\Controllers\Api\RbMockController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/



Route::prefix('mock')->group(function () {
    Route::post('offer/rough-offer', [RbMockController::class, 'roughOffer']);
    Route::post('offer/inquiry', [RbMockController::class, 'inquiry']);
    Route::post('offer/export', [RbMockController::class, 'export']);
    Route::post('offer/initial-offer', [RbMockController::class, 'initialOffer']);
    Route::post('offer/initial-offer/{offerId}/decision', [RbMockController::class, 'decideInitialOffer']);
    Route::post('offer/final-offer/{offerId}/decision', [RbMockController::class, 'finalOfferDecision']);
    Route::post('offer/cancel-offer/{offerId}', [RbMockController::class, 'cancelOffer']);
    Route::get('offer/status/{offerId}', [RbMockController::class, 'status']);
});
