<?php

return [
    'base_url' => env('MOCK_BASE_URL', 'https://87a0d6a8-5b0a-4d2a-b8bf-a26f1f20dc6e.mock.pstmn.io'),

    'operator_txn' => [
        'send_in' => 'both', // بدل 'body' لو عايزه يوصل في GET كمان
        'header_name' => 'Operator-Transaction-Number',
        'body_key' => 'operatorTransactionNumber',
        'prefix' => 'RB',
    ],

    'bodies' => [
        // POST /offer/rough-offer
        'rough_offer' => [
            'header' => ['sender' => 'Fintech', 'receiver' => 'RB', 'timestamp' => 1750765267345],
            'nationality' => 'Saudi', 'sector' => 'PRIVATE', 'monthlyIncome' => 35000,
            'typeOfSalary' => 'SALARY_TRANSFER', 'personalLoanObligation' => 2000,
            'creditCardObligation' => 0, 'mortgageObligation' => 0, 'autoLeaseObligation' => 0,
            'financePeriodInMonths' => 60, 'userBirthDay' => '01/04/1990',
        ],
        // POST /offer/inquiry
        'inquiry' => [
            'header' => ['sender' => 'Fintech', 'receiver' => 'RB', 'timestamp' => 1750765267345],
            'pageNumber' => 1, 'pageSize' => 30, 'sortBy' => 'createdAt', 'sortOrder' => 'desc',
            'filterKeys' => [
                'thirdPartyIdentifierId' => '', 'startDate' => '', 'endDate' => '',
                'minLoanAmount' => 1, 'maxLoanAmount' => 4000000,
                'status' => ['FINAL_OFFER_ACCEPTED', 'INITIAL_OFFER_GENERATED'],
            ],
        ],
        // POST /offer/export
        'export' => [
            'header' => ['sender' => 'Fintech', 'receiver' => 'RB', 'timestamp' => 1750765267345],
            'pageNumber' => 1, 'pageSize' => 3, 'sortBy' => 'createdAt', 'sortOrder' => 'desc',
            'filterKeys' => ['status' => ['FINAL_OFFER_ACCEPTED', 'INITIAL_OFFER_GENERATED']],
            'selectedFieldsMap' => ['offerId' => 'Application Id', 'cusPhone' => 'Customer Phone'],
            'offerId' => '', 'checkExportAllRequest' => true,
        ],
        // POST /offer/initial-offer  (مع Headers خاصة)
        'initial_offer' => [
            'header' => ['sender' => 'Fintech', 'receiver' => 'RB', 'timestamp' => 123456789],
            'productCode' => 'PL-001',

            'customerPersonalDetails' => [
                'nationality' => 1, 'gender' => 1, 'maritalStatus' => 1,
                'educationLevel' => 2, 'noOfChildren' => 2, 'noOfDependents' => 3, 'religion' => 1,
                'residentStatus' => 1, 'residentSince' => '2010-01-01', 'dateOfBirth' => '1990-04-01',
            ],
            'customerAddressDetails' => [
                'homeAddress' => 'Riyadh', 'city' => 1, 'state' => 1, 'country' => 'Saudi Arabia', 'zipCode' => '11564',
            ],
            'customerContactDetails' => [
                'emailAddress' => 'user@example.com', 'mobilePhoneNumberCountryCode' => '+966', 'mobilePhoneNumber' => '500000000',
            ],
            'customerBankDetails' => [
                'isRBAccount' => false, 'ibanNumber' => 'SA0000000000000000000000',
            ],
            'customerIncomeExpenseDetails' => [
                'incomeDetails' => [
                    'incomeType' => 1, 'incomePaymentMethod' => 1, 'incomeFrequency' => 1, 'variableIncome' => 0,
                    'guaranteedIncome' => 20000, 'overtimeIncome' => 0, 'transportAllowance' => 1000,
                    'otherAllowance' => 800, 'fixedAllowance' => 0, 'totalIncome' => 21800,
                ],
                'expenseDetails' => [
                    'rentExpense' => 2000, 'utilitiesExpense' => 500, 'foodExpense' => 800, 'transportationExpense' => 500,
                    'educationExpense' => 1000, 'domesticHelp' => 500, 'futureExpense' => 1000, 'mps' => 400, 'totalExpenses' => 6800,
                ],
            ],
            'customerEmployerDetails' => [
                'employerSegment' => 2, 'employerName' => '1602', 'employerCommercialRegistrationNumber' => '1010061656',
                'employmentStartDate' => '2015-06-01', 'employmentEndDate' => '2030-08-31', 'salaryDay' => 28,
                'salaryDetails' => ['basicSalary' => 20000, 'housingAllowance' => 3000],
            ],
            'customerSecondaryIncome' => [
                'secondaryIncomeType' => 'I', 'secondaryIncomeAmount' => '2000', 'secondaryIncomeFrequency' => 'M',
            ],
            'loanDetails' => ['purposeOfLoan' => 2, 'homeOwnership' => 1, 'residentialType' => 1],
        ],
        // POST /offer/initial-offer/{offerId}/decision
        'decide_initial_offer' => [
            'header' => ['sender' => 'Fintech', 'receiver' => 'RB', 'timestamp' => 1750765267345],
            'decisionStatus' => 'ACCEPTED', 'rejectionReason' => '', 'loanAmount' => 30000, 'loanPeriod' => 24,
        ],
        // POST /offer/final-offer/{offerId}/decision
        'final_offer_decision' => [
            'header' => ['sender' => 'Fintech', 'receiver' => 'RB', 'timestamp' => 1750765267345],
            'decisionStatus' => 'ACCEPTED', 'rejectionReason' => '',
        ],
        // POST /offer/cancel-offer/{offerId}
        'cancel_offer' => [
            'header' => ['sender' => 'Fintech', 'receiver' => 'RB', 'timestamp' => 1750765267345],
            'cancelReason' => 'Cancel',
        ],
    ],

    // Headers الخاصة بـ initial-offer كما بالكولكشن
    'initial_offer_headers' => [
        'User-Name' => 'Reem',
        'User-Id' => '6612113',
        'client_id' => '499142c708304459af1f7a49ca9113c0',
    ],
];
